<?php
/**
 * WPSEO Premium plugin file.
 *
 * @package WPSEO\Premium\Classes\Redirect\Exporters
 */

/**
 * Class WPSEO_Htaccess_Redirect_File
 */
class WPSEO_Redirect_Htaccess_Exporter extends WPSEO_Redirect_Apache_Exporter {

	/**
	 * Save the redirect file
	 *
	 * @param string $file_content The file content that will be saved.
	 *
	 * @return bool
	 */
	protected function save( $file_content ) {
		$file_path = WPSEO_Redirect_Htaccess_Util::get_htaccess_file_path();

		// Update the .htaccess file.
		if ( is_writable( $file_path ) ) {
			$htaccess = $this->get_htaccess_content( $file_path, $file_content );
			$return   = (bool) WPSEO_Redirect_File_Util::write_file( $file_path, $htaccess );

			// Make sure defines are created.
			WP_Filesystem();
			chmod( $file_path, FS_CHMOD_FILE );

			return $return;
		}

		return false;
	}

	/**
	 * Getting the content from current .htaccess
	 *
	 * @param string $file_path    The location of the htaccess file.
	 * @param string $file_content THe content to save in the htaccess file.
	 *
	 * @return string
	 */
	private function get_htaccess_content( $file_path, $file_content ) {
		// Read current htaccess.
		$htaccess = '';
		if ( file_exists( $file_path ) ) {
			$htaccess = file_get_contents( $file_path );
		}

		$htaccess = preg_replace( '`# BEGIN YOAST REDIRECTS.*# END YOAST REDIRECTS' . PHP_EOL . '`is', '', $htaccess );

		// Only add redirect code when redirects are present.
		if ( ! empty( $file_content ) ) {
			$file_content = '# BEGIN YOAST REDIRECTS' . PHP_EOL . '<IfModule mod_rewrite.c>' . PHP_EOL . 'RewriteEngine On' . PHP_EOL . $file_content . '</IfModule>' . PHP_EOL . '# END YOAST REDIRECTS' . PHP_EOL;

			// Prepend our redirects to htaccess file.
			$htaccess = $file_content . $htaccess;
		}

		return $htaccess;
	}

	/**
	 * Escape special characters in the URL that will cause problems in .htaccess.
	 *
	 * Overrides WPSEO_Redirect_Apache_Exporter::format_url.
	 *
	 * @param string $url The URL.
	 *
	 * @return string The escaped URL.
	 */
	protected function format_url( $url ) {
		$url = parent::format_url( $url );

		return $this->sanitize( $url );
	}

	/**
	 * Escape special characters that will cause problems in .htaccess.
	 *
	 * @param string $unsanitized The unsanitized value.
	 *
	 * @return string The sanitized value.
	 */
	private function sanitize( $unsanitized ) {
		return str_replace(
			[
				'\\',
				'"',
			],
			[
				'/',
				'\"',
			],
			$unsanitized
		);
	}
}
